%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Open Systems                                                            %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% ---------------DEFINE ANALYTICAL SOLUTION------------------------------%
% T_lauw_linear.m   : Lauwerier 1954 - Linear flow             (1)        %
% T_avd_linear.m    : Avnonin 1964 - Linear flow               (2)        %
% T_lauw_radial.m   : Malofeev 1960 - Radial flow              (3)        %
% T_avd_radial.m    : Avnonin 1964  - Radial flow              (4)        %
% T_guimera.m       : Guimera 2007 - Radial flow               (5)        %

clear;clc

%% ------------------------ INPUT PARAMETERS -----------------------------% 
% Input the number of the analytical solution you want to evaluate
test = 1;
while any(test) % Test input
   prompt = {'Lauwerier 1954 - Linear flow  = 1, Avnonin 1964 - Linear flow  = 2, Malofeev 1960 - Radial flow  = 3, Avnonin 1964  - Radial flow  = 4, Guimera 2007 - Radial flow  = 5; Analytical solution you want to evaluate:  '};
   dlg_title = 'Analytical solutions:';
   num_lines= 1;
   def     = {'1'};
   geometrie  = inputdlg(prompt,dlg_title,num_lines,def);
   fAS = str2num(geometrie{1}); fASTrue = isempty(fAS);
   test = [fASTrue];
end

% Input Space discretization
test = 1;
while any(test) % Test input
   prompt = {'minimum x-coordinate xmin [m]:','maximum x-coordinate xmax>xmin: [m]',...
       'aquifer thickness [m]','veritical coordinate in the aquifer [m] (z>=h/2)','number of space steps'};
   dlg_title = 'Space discretization';
   num_lines= 1;
   def     = {'0.1','50','10','5','500'};
   geometrie  = inputdlg(prompt,dlg_title,num_lines,def);
   xmin = str2num(geometrie{1}); xminTrue = isempty(xmin);
   xmax = str2num(geometrie{2}); xmaxTrue = isempty(xmax); xmaxTrue2=(xmax<=xmin);
   h   = str2num(geometrie{3}); hTrue = isempty(h);
   z   = str2num(geometrie{4}); zTrue = isempty(z);
   Mx   = str2num(geometrie{5}); MxTrue = isempty(Mx);
   test = [xminTrue; xmaxTrue; MxTrue; xmaxTrue2];
end

% Input Time discretization
test = 1;
while any(test) % Test input
   prompt = {'simulation time [days]:'};
   dlg_title = 'Simulation time';
   num_lines= 1;
   def     = {'100'};
   geometrie  = inputdlg(prompt,dlg_title,num_lines,def);
   tf = str2num(geometrie{1}); tfTrue = isempty(tf);
   test = [tfTrue];
end

% Input flow and heat transport parameters
test = 1;
while any(test) % Test numerical input
    prompt = {'Vol. heat capacity of aquifer [J kg-3 K-1]','Vol. heat capacity of confining layer [J kg-3 K-1]',...
        'Vol. heat capacity of water [J m-3 K-1]','thermal conductivity of aquifer [W m-1 K-1]',...
        'thermal conductivity of confining layer [W m-1 K-1]','longitudinal dispersivity [m]:',...
        'Specific flux (Darcy flux) [m s-1]:','Flow rate injection [m3 s-1]:'};
    dlg_title = 'Transportparameter';
    num_lines = 1;
    def     = {'2.8E6','2.8E6','4.2E6','2.5','2.5','0.1','2.25E-6','0.1/1000'};
    transportparameter  = inputdlg(prompt,dlg_title,num_lines,def);
    Cm = str2num(transportparameter{1}); CmTrue = isempty(Cm);
    Cm2 = str2num(transportparameter{3}); Cm2True = isempty(Cm2);
    Cw = str2num(transportparameter{3}); CwTrue = isempty(Cw);
    lm = str2num(transportparameter{4}); lmTrue = isempty(lm);
    lm2 = str2num(transportparameter{5}); lm2True = isempty(lm2);
    ax = str2num(transportparameter{6}); axTrue = isempty(ax);
    q = str2num(transportparameter{7}); qTrue = isempty(q);
    Q = str2num(transportparameter{8}); QTrue = isempty(Q);
    test = [CmTrue; Cm2True; CwTrue; lmTrue; lm2True; axTrue; qTrue; QTrue];
end 

%% ------------------------TIME DISCRETIZATION----------------------------%
% Simulation Time
t = tf*86400;             % [s]

%% ---------------SPACE DISCRETIZATION AND BOREHOLES----------------------%
% Space discretization
% minimum and maximum x coordinate [m]
rs = [xmin xmax];             

%% -------------------------EXECUTION-------------------------------------%
% Heat transport velocity [m/s]
vT = q*Cw/Cm;

% Meshgrid
r = linspace(rs(1),rs(2),Mx);       % x coordinate [m]
% Assign the analitical solution to the variable Sol
Sol = {'T_lauw_linear';'T_avd_linear';'T_lauw_radial';'T_avd_radial';'T_guimera'};
    
for i=1:length(r) 
    T(i) = eval([ Sol{fAS} '(r(i),z,h,lm,lm2,Cw,Cm,Cm2,vT,t,Q,ax)']);
end
  
%% -----------------------PLOT--------------------------------------------%
figure
plot(r,T,'k--','LineWidth',1.0)
xlabel ('Distance from the well [m]','FontSize',16); h = ylabel ('Normalized Temperature','FontSize',16);
ylim([0 1]);  xlim([0 r(end)]);
set(gca,'LineWidth',1.0,'FontSize',16,'FontName','Arial')